/*!Copyright(c) 2010-2014 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 *\file     mc_common.h
 *\brief    commno data struct. 
 *
 *\author   liang liang
 *\version  1.0.0
 *\date     2014-07-05
 *
 *\history 
 *                  
 *          \arg 1.0.0, 2014-07-05, liang liang, Create the file.
 */


#ifndef __MC_COMMON_H_
#define __MC_COMMON_H_

#include "os_type.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define MC_NAME_LEN 64

#define MC_MAP_SET(map, bit) ((map)[(bit) >> 3] |= 1 << ((bit) & 7))
#define MC_MAP_CLR(map, bit) ((map)[(bit) >> 3] &= ~(1 << ((bit) & 7)))
#define MC_MAP_ISSET(map, bit) (((map)[(bit) >> 3] & (1 << ((bit) & 7))) != 0)

#define MC_BIND_UDP_ADDR "127.0.0.1"
#define MC_BIND_UNIX_ADDR "/tmp/msgcenter_unix"

#define MC_SEND_MAX_COUNT 2
#define MC_WIFI_BAND_MAX_NUM 2


typedef enum _MC_PORT
{
    MC_PORT_SERVER = 6600,
    MC_PORT_SMARTIP,
    MC_PORT_WIFI,
    MC_PORT_DHCP,
    MC_PORT_WPS,
    MC_PORT_WPS_INFO,
    MC_PORT_WIFI_SCAN,
    MC_PORT_GPIO,
    MC_PORT_LANSETTING_ACK,
    MC_PORT_LANSETTING_RES,
    MC_PORT_WIFIMV,
    MC_PORT_WIFIMV_MODS,
    MC_PORT_PLC,
    MC_PORT_DST,
    MC_PORT_WIFISCHED,
    MC_PORT_NTP,
    MC_PORT_LEDSCH,
    MC_PORT_TDDP,
    MC_PORT_MAX
}MC_PORT;


typedef enum _MC_EVENT
{
    MC_EVENT_NONE = 0,
    /* add something*/
    /* example: MC_EVENT_SMARTIP*/
    MC_EVENT_SMARTIP,
    MC_EVENT_DHCP,
    MC_EVENT_WIFI,
    MC_EVENT_GPIO,
    MC_EVENT_TIMERJOB,
    MC_EVENT_WPS,
    MC_EVENT_WPS_INFO,
    MC_EVENT_WIFIMV,
    MC_EVENT_PLC,
    MC_EVENT_LANSETTING_ACK,
    MC_EVENT_LANSETTING_RES,      
    MC_EVENT_DST,
    MC_EVENT_WIFISCHED,
    MC_EVENT_NTP,  
    MC_EVENT_LEDSCH,
    MC_EVENT_CLOUD,
    MC_EVENT_CWMP,
    MC_EVENT_MAX
}MC_EVENT;

typedef enum _MC_PRIO
{
    MC_PRIO_NONE = 0,
    MC_PRIO_HIGH,   /* sync : high    */
    MC_PRIO_NORMAL,     /* sync : normal  */
    MC_PRIO_LOW,        /* sync : low     */
    MC_PRIO_DEFAULT,    /* async: default */
    MC_PRIO_MAX
}MC_PRIO;

typedef enum _MC_CB_TYPE
{
    MC_CB_TYPE_NONE = 0,
    MC_CB_TYPE_SYNC,   /* sync  */
    MC_CB_TYPE_ASYNC,  /* async */
    MC_CB_TYPE_MAX
}MC_CB_TYPE;

typedef enum _MC_ROLE
{
    MC_ROLE_NONE = 0,
    MC_ROLE_PUBLISHER,   /* publisher  */
    MC_ROLE_SUBSCRIBER,      /* subscriber */
    MC_ROLE_MAX
}MC_ROLE;

typedef enum _MC_MSG_TYPE
{
    MC_MSG_TYPE_NONE = 0,
    MC_MSG_TYPE_REG,   /* register info  */
    MC_MSG_TYPE_UNREG,   /* register info  */
    MC_MSG_TYPE_DATA,  /* data */
    MC_MSG_TYPE_ACK,
    MC_MSG_TYPE_MAX
}MC_MSG_TYPE;

typedef enum _MC_SMARTIP_ACTION
{
	MC_SMARTIP_NONE = 0,
	MC_SMARTIP_DHCP,
	MC_SMARTIP_WIFI,
	MC_SMARTIP_IPCHANGE,
	MC_SMARTIP_MAX
} MC_SMARTIP_ACTION;

typedef enum _MC_WIFI_ACTION
{
	MC_WIFI_NONE=0,
	MC_WIFI_RESTART,
	MC_WIFI_STOP,
	MC_WIFI_ACL,
	MC_WIFI_CHANGE_CFG,
	MC_WIFI_GET_CLIENTS,
	MC_WIFI_GUEST_PARM,
	MC_WIFI_GUEST_STOP,
	MC_WIFI_START,
	MC_WIFI_DISCONN_STA,
	MC_WIFI_STOP_FINISH, /*add indiate wifi stop finished*/
#if defined(TPAPPS_NRD)	
	MC_WIFI_ROAMING,
#endif
	MC_WIFI_MAX
}MC_WIFI_ACTION;

typedef enum _MC_WIFIMV_ACTION
{
    MC_WIFIMV_NONE=0,
    MC_WIFIMV_ONOFF,
    MC_WIFIMV_CLONE,
    MC_WIFIMV_CFG_EFFECT,
    MC_WIFIMV_INPULSE,
    MC_WIFIMV_WIFISCH_CFG,
    MC_WIFIMV_IN_PLCNET,
    MC_WIFIMV_MAX
}MC_WIFIMV_ACTIOIN;

typedef enum _MC_LEDSCH_ACTION
{
    MC_LEDSCH_NONE=0,
    MC_LEDSCH_CFG,
    MC_LEDSCH_TOGGLE,
    MC_LEDSCH_UPDATE,
    MC_LEDSCH_RTCFG,
    MC_LEDSCH_WIFIMV,
    MC_LEDSCH_MAX
}MC_LEDSCH_ACTION;

typedef enum _MC_CLOUD_ACTION
{
	MC_CLOUD_NONE = 0, 
	MC_CLOUD_UPGRADE,
    MC_CLOUD_SET_ACCOUNT
}MC_CLOUD_ACTION;

typedef enum _MC_PLC_ACTION
{
	MC_PLC_NONE=0,
	MC_PLC_LOCAL_WRITE,	/*subcreiber aciton*/
    MC_PLC_NMK_WRITE,
	MC_PLC_DEVICE_GET,
	MC_PLC_DEVICE_REMOVE,
	MC_PLC_DEVICE_ADD,
	MC_PLC_LOCAL_PARA_GET,
	MC_PLC_ALL_NMK_SET,
	MC_PLC_RMT_HFID_GET,
	MC_PLC_RMT_LED_SET,
	MC_PLC_LOC_RESET,
    MC_PLC_LOCAL_RESTART,
	MC_PLC_RMT_RESET,
	MC_PLC_ALL_RESET,	
	MC_PLC_RMT_NWINFO,
	MC_PLC_UPGRADE,
	MC_PLC_PAIR,
	MC_PLC_LEAVE,
	MC_PLC_ETH_STATUS,
	MC_PLC_KICK_LAN_STA,

	MC_PLC_SUB_MAX,		/*max subcriber action */
	
	MC_PLC_DEVICE_ADDED,	/*publisher action*/
	MC_PLC_LOCAL_NTWCHANGED,
	MC_PLC_GET_NVMPIB,
	MC_PLC_GET_GGL,
	MC_PLC_MAX,
}MC_PLC_ACTION;

typedef enum _MC_CWMP_ACTION
{
    MC_CWMP_NONE=0,
    MC_CWMP_SET,
    MC_CWMP_GET,
    MC_CWMP_MAX
}MC_CWMP_ACTION;

typedef struct __MC_PLC_NFO
{
	char macAddr[18];
	char devName[25];
	char devPwd[20];
	char ntwName[24];
    char nmkStr[32 + 1];
	char ledState;
	char from[15];
	char lanPort;
}MC_PLC_INFO;

typedef struct _MC_EVENT_DATA_PLC
{
    MC_PLC_ACTION action;
	MC_PLC_INFO	info;
}MC_EVENT_DATA_PLC;

typedef struct _MC_REG_INFO
{
    os_s8 module_name[MC_NAME_LEN + 1]; //share library name, for sync
    os_s32 pid; //getpid
    os_u8 event[(MC_EVENT_MAX >> 3) + 1]; //MC_EVENT
    os_u8 prio; // MC_PRIO
    os_u8 type; // MC_CB_TYPE
    os_u8 role; // MC_ROLE
    os_u16 port; // for subscriber udp
    
}MC_REG_INFO;

typedef struct _MC_DHCPC_INFO
{
	os_u32 ip;
	os_u32 mask;
	os_u32 gw;
	os_u32 dns[2];	/* 2 dns is enough */
}MC_IP_INFO;

typedef struct _MC_ENEVT_DATA_SMARTIP
{
	MC_SMARTIP_ACTION action;
	union {
		os_u16 detect_result; /*dhcpc detects dhcps result:0 success, 1 fail*/
		os_u16 wifi_status;	  /*wifi_status:0 no change, 1 connected->disconnected, 2 disconnected->connected, 3 rootap changed*/
		os_u16 lanip_changed; /*for smartip pub msg:0 lanip no change, 1 lanip changed*/
	} status;
	MC_IP_INFO payload; /*the payload of msg*/
}MC_EVENT_DATA_SMARTIP;

typedef struct _MC_EVENT_DATA_WIFI
{
    os_u32 change_status;
    os_u32 band_mode;
	MC_WIFI_ACTION action;
}MC_EVENT_DATA_WIFI;


typedef struct _MC_EVENT_DATA_TIMERJOB
{
	os_u16 timerjob_status;		/* timerjob status:0 led off, 1 led on */
}MC_EVENT_DATA_TIMERJOB;

typedef enum _MC_NTP_ACTION
{
	MC_NTP_NONE = 0,
	MC_NTP_KILL,
    MC_NTP_RESET,
    MC_NTP_REQUEST,
    MC_NTP_GET_GMT,
	MC_NTP_MAX
} MC_NTP_ACTION;

typedef struct _MC_EVENT_DATA_NTP
{
	MC_NTP_ACTION action;
}MC_EVENT_DATA_NTP;

typedef enum _MC_WIFISCHED_ACTION
{
	MC_WIFISCHED_NONE = 0,
	MC_WIFISCHED_KILL,
    MC_WIFISCHED_RESET,
    MC_WIFISCHED_DISABLE,
	MC_WIFISCHED_CHANGE_CFG,
	MC_WIFISCHED_RTCFG,
	MC_WIFISCHED_MAX
} MC_WIFISCHED_ACTION;

typedef struct _MC_EVENT_DATA_WIFISCHED
{
	MC_WIFISCHED_ACTION action;
}MC_EVENT_DATA_WIFISCHED;

typedef enum _MC_DST_ACTION
{
	MC_DST_NONE = 0,
	MC_DST_KILL,
    MC_DST_RESET,
    MC_DST_RUN,
    MC_DST_NTP,
	MC_DST_MAX
} MC_DST_ACTION;

typedef struct _MC_EVENT_DATA_DST
{
	MC_DST_ACTION action;
}MC_EVENT_DATA_DST;

typedef struct _MC_EVENT_DATA_LANSETTING
{
	os_s32 is_write;// read or write config
	MC_EVENT res_event; // to respond the sender
}MC_EVENT_DATA_LANSETTING;
typedef struct _MC_EVENT_DATA_WIFIMV
{
    MC_WIFIMV_ACTIOIN action;
    union{
    os_u32 onoff;
    }data;
}MC_EVENT_DATA_WIFIMV;

typedef struct _MC_EVENT_DATA_LEDSCH
{
    MC_LEDSCH_ACTION action;
    union{
        os_u32 onoff;
    }data;
}MC_EVENT_DATA_LEDSCH;

typedef struct _MC_EVENT_DATA_CWMP
{
    MC_CWMP_ACTION action;    
    struct {
    os_u32 op_mod;
    os_u32 res;
    }data;
}MC_EVENT_DATA_CWMP;


#ifndef  __OP_CLOUD_INFO_H__
typedef struct _CLOUD_ACCOUNT {
    char username[32];
    char email[32];
    char phone[32];
	char password[32];
	int role;
	int loginStatus;
} CLOUD_ACCOUNT;

typedef struct _CLOUD_ACCOUNT_INFO {
    int userNum;
    int hasBind;
	int needToUnbind; /*add by ZQQ, 2017.12.12, record the unbind status before factory default restore*/
    char alias[32];
    CLOUD_ACCOUNT owner;
    CLOUD_ACCOUNT user[32];
} CLOUD_ACCOUNT_INFO;
#endif

typedef struct _MC_EVENT_DATA_CLOUD
{
	MC_CLOUD_ACTION action;
    CLOUD_ACCOUNT_INFO accountInfo;
}MC_EVENT_DATA_CLOUD;

/* wps */
typedef enum _MC_WPS_ACTION
{
	MC_WPS_NONE = 0,
	MC_WPS_KILL,
	MC_WPS_RELOAD,
    MC_WPS_CONNET,
    MC_WPS_WIFICLONE,
    MC_WPS_CANCEL,
	MC_WPS_MAX
} MC_WPS_ACTION;

typedef enum _MC_WPS_METHOD
{
	MC_WPS_METHOD_NONE = 0,
	MC_WPS_METHOD_PBC,
	MC_WPS_METHOD_PIN,
	MC_WPS_METHOD_MAX
} MC_WPS_METHOD;

typedef struct _MC_EVENT_DATA_WPS
{
	MC_WPS_ACTION action;
    MC_WPS_METHOD method;
}MC_EVENT_DATA_WPS;

/* wps info */
typedef enum _MC_WPS_INFO
{
	MC_WPS_INFO_NONE = 0,
    MC_WPS_INFO_START,
    MC_WPS_INFO_SUCCESS,
    MC_WPS_INFO_FINISH,
    MC_WPS_INFO_CFGCHANGE,
	MC_WPS_INFO_MAX
} MC_WPS_INFO;

typedef struct _MC_EVENT_DATA_WPS_INFO
{
    MC_WPS_INFO info;
    int bandMode;
    int resBandMode;
} MC_EVENT_DATA_WPS_INFO;

/* gpio */
typedef enum _MC_GPIO_ACTION
{
	MC_GPIO_NONE = 0,
	MC_GPIO_ON,
	MC_GPIO_OFF,
	MC_GPIO_CHK_STS,
	MC_GPIO_PAIR,
	MC_GPIO_UNPAIR,
	MC_GPIO_LED_ON,
	MC_GPIO_LED_OFF,
	MC_GPIO_WIFI_2G_ON,
	MC_GPIO_WIFI_5G_ON,
	MC_GPIO_WIFI_ALL_ON,
	MC_GPIO_RESET_FACTORY,
    MC_GPIO_UC_ON,
    MC_GPIO_UC_OFF,
	MC_GPIO_WIFI_OFF,		
#if defined(RECORD_GPIO_STATUS)
	MC_GPIO_RECORD_GPIO_STATUS,		
#endif
	MC_GPIO_SYS_ON,
	MC_GPIO_SYS_OFF,
	MC_GPIO_MAX
} MC_GPIO_ACTION;

typedef struct _MC_GPIO_PORT
{
	os_u8 port;
}MC_GPIO_PORT;


typedef struct _MC_EVENT_DATA_GPIO
{
	MC_GPIO_ACTION action;
    	MC_GPIO_PORT port;		
#if defined(RECORD_GPIO_STATUS)
	unsigned int record_gpio;
#endif
}MC_EVENT_DATA_GPIO;


typedef struct _MC_EVENT_DATA
{
    os_u32 event;
    os_s32 pid;
    os_u32 seq;
    
    union {
        /* add something */
        /* example: MC_EVENT_DATA_SMARTIP */
        MC_EVENT_DATA_SMARTIP 	data_smartip;
	 	MC_EVENT_DATA_WIFI 		data_wifi;
	 	MC_EVENT_DATA_TIMERJOB 	data_timerjob;
		MC_EVENT_DATA_WPS		data_wps;
		MC_EVENT_DATA_WPS_INFO	data_wps_info;
        MC_EVENT_DATA_WIFIMV    data_wifimv;
		MC_EVENT_DATA_PLC		data_plc;
		MC_EVENT_DATA_LANSETTING	data_LanSetting;
		MC_EVENT_DATA_DST		data_dst;
		MC_EVENT_DATA_WIFISCHED		data_wifiSched;
		MC_EVENT_DATA_NTP	data_ntp;
		MC_EVENT_DATA_GPIO	data_gpio;
        MC_EVENT_DATA_LEDSCH data_ledsch;
		MC_EVENT_DATA_CLOUD	data_cloud;
        MC_EVENT_DATA_CWMP  data_cwmp;
    }data;
	
}MC_EVENT_DATA;

typedef struct _MC_HANDLE
{
    os_s32 unix_sock;
    os_s32 udp_sock;
}MC_HANDLE;

typedef MC_HANDLE* mc_handle_t;


//Internal use only
typedef struct _MC_MSG
{
    os_u8 msg_type; //MC_MSG_TYPE
    os_u16 msg_len;

    union {
        MC_EVENT_DATA data;
        MC_REG_INFO reg;
    }body;
}MC_MSG;



typedef os_s32 (*mc_sync_callback)(MC_EVENT_DATA* data, void* unused);


/*!
 *\fn       os_s32 mc_sub_attach(mc_handle_t s, MC_REG_INFO* info)
 *\brief    subcriber register event.
 *
 *\param[out]    s
 *\param[in]    info
 *
 *\return   result of the reg
 *\retval   = 0  The register ok.
 *\retval   < 0  The register failed.
 */
os_s32 mc_sub_attach(mc_handle_t s, MC_REG_INFO* info);


/*!
 *\fn       os_s32 mc_sub_detach(mc_handle_t s, MC_REG_INFO* info)
 *\brief    subcriber unregister event.
 *
 *\param[in]    s
 *\param[in]    info
 *
 *\return   result of the unreg
 *\retval   = 0  The unregister failed.
 *\retval   < 0  The unregister failed.
 */
os_s32 mc_sub_detach(mc_handle_t s, MC_REG_INFO* info);


/*!
 *\fn       os_s32 mc_sub_handle(mc_handle_t s)
 *\brief    subcriber get udp socket.
 *
 *\param[in]    s
 *
 *\return   udp socket
 */
os_s32 mc_sub_handle(mc_handle_t s);


/*!
 *\fn       os_s32 mc_sub_recv(mc_handle_t s, MC_EVENT_DATA* data, os_u32* len)
 *\brief    subscriber recv msg.
 *
 *\param[in]    s
 *\param[out]   data
 *\param[out]   len
 *
 *\return   result of the recv msg
 *\retval   = 0  The recv succeeded.
 *\retval   < 0  The recv failed.
 */
os_s32 mc_sub_recv(mc_handle_t s, MC_EVENT_DATA* data, os_u32* len);


/*!
 *\fn       os_s32 mc_pub_attach(mc_handle_t s, void* unused)
 *\brief    publisher register.
 *
 *\param[out]   s
 *\param[in]    unused(reserved)
 *
 *\return   result of the reg
 *\retval   = 0  The register ok.
 *\retval   < 0  The register failed.
 */
os_s32 mc_pub_attach(mc_handle_t s, void* unused);


/*!
 *\fn       os_s32 mc_pub_detach(mc_handle_t s, void* unused)
 *\brief    publisher unregister.
 *
 *\param[in]    s
 *\param[in]    unused(reserved)
 *
 *\return   result of the unreg
 *\retval   = 0  The unregister ok.
 *\retval   < 0  The unregister failed.
 */
os_s32 mc_pub_detach(mc_handle_t s, void* unused);


/*!
 *\fn       os_s32 mc_sub_recv(mc_handle_t s, MC_EVENT_DATA* data, os_u32* len)
 *\brief    publisher send msg.
 *
 *\param[in]    s
 *\param[in]   indo
 *\param[in]   len
 *
 *\return   result of the send msg
 *\retval   = 0  The send succeeded.
 *\retval   < 0  The send failed.
 */
os_s32 mc_pub_send(mc_handle_t s, MC_EVENT_DATA* info, os_u32 len);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __MC_COMMON_H_ */

